//=============================================================================
// BowelDrop.
//=============================================================================
class BowelDrop extends DeusExFragment;

#exec TEXTURE IMPORT NAME="GreenJuice" FILE="C:\DeusEx\Legos\Green.pcx" GROUP=Skins

auto state Flying
{
	function HitWall(vector HitNormal, actor Wall)
	{
		spawn(class'BowelSplat',,, Location, Rotator(HitNormal));
		Destroy();
	}
	function BeginState()
	{
		Velocity = VRand() * 100;
		DrawScale = 1.0 + FRand();
		SetRotation(Rotator(Velocity));
	}
}

function Tick(float deltaTime)
{
	if (Velocity == vect(0,0,0))
	{
		spawn(class'BowelSplat',,, Location, rot(16384,0,0));
		Destroy();
	}
	else
		SetRotation(Rotator(Velocity));
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		ScaleGlow = 2.0;
		DrawScale *= 1.5;
		LifeSpan *= 2.0;
		bUnlit=True;
	}
}

defaultproperties
{
     Style=STY_Modulated
     Mesh=LodMesh'DeusExItems.BloodDrop'
     CollisionRadius=0.000000
     CollisionHeight=0.000000
     bBounce=False
     NetPriority=1.000000
     NetUpdateFrequency=5.000000
     MultiSkins(0)=Texture'GreenJuice'
     MultiSkins(1)=Texture'GreenJuice'
     MultiSkins(2)=Texture'GreenJuice'
     MultiSkins(3)=Texture'GreenJuice'
     MultiSkins(4)=Texture'GreenJuice'
     MultiSkins(5)=Texture'GreenJuice'
     MultiSkins(6)=Texture'GreenJuice'
     MultiSkins(7)=Texture'GreenJuice'
}
